require "prefabutil"
local Widget = require "widgets/widget"
local assets=
{
	Asset("ANIM", "anim/goldfish.zip"),
	Asset("IMAGE", "images/inventoryimages/goldfish.tex"),
	Asset("ATLAS", "images/inventoryimages/goldfish.xml"),
}

local function itemtest(inst, item, slot)
	if not ( item:HasTag("backpack")) then
			return true
end
end

local slotpos = {}

for y = 0, 6 do
	table.insert(slotpos, Vector3(-162, -y*75 + 240 ,0))
	table.insert(slotpos, Vector3(-162 +75, -y*75 + 240 ,0))
end

local function onequip(inst, owner) 
	--owner.AnimState:OverrideSymbol("swap_body", "swap_backpack", "backpack")
	owner.AnimState:OverrideSymbol("swap_body", "goldfish", "swap_body")
	owner.components.inventory:SetOverflow(inst)
    inst.components.container:Open(owner)
end


local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	--owner.AnimState:ClearOverrideSymbol("backpack")
	 owner.AnimState:ClearOverrideSymbol("backpack")
    owner.components.inventory:SetOverflow(nil)
    inst.components.container:Close(owner)

end


local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("goldfish")
    inst.AnimState:SetBuild("goldfish")
   inst.AnimState:PlayAnimation("idle", false)
    	

	inst:AddTag("waterproofer")
	inst:AddTag("backpack")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.cangoincontainer = true
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/backpack"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/goldfish.xml"

    
    	inst:AddComponent("inspectable")
		
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0)
	
	inst:AddComponent("container")
	    inst.components.container.itemtestfn = itemtest
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_krampusbag_2x8"
    inst.components.container.widgetanimbuild = "ui_krampusbag_2x8"
	inst.components.container.widgetpos = Vector3(-5,-70,0)
	inst.components.container.type = "pack"
	
	inst.components.container.side_widget = true   
	
	if IsDLCEnabled(0002) then
	MakeInventoryFloatable(inst, "anim", "anim")
	end
	
    return inst
end

return Prefab( "common/inventory/goldfish", fnab, assets) 